//Experiment No.7
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at    
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
//This Source file is Written by Dr. T. Subbulaskhmi, Professor, 
//School of Computing Science and Engineering, VIT University Chennai 
//using the NARVAL examples of Scilab for Network Topology Creation  
//The Operating System used for writing the code found in this file is Windows 8
//SCILAB version 5.5.2 and NARVAL toolbox version 3.1//This Program is Written by Souarv kumar Surya(15bce1364),Prayag Bhatia (15bce1363),Maaz Ahmed (15bce1261), School of Computing Science and Engineering, VIT University Chennai using the NARVAL examples of Scilab 
//This is the scilab code to find the Shortest path from source to destination in ring topology network using flood for 10 nodes. 
clear;
clc;

NameOfNetwork=' shortest path from source to destinetion in ring topology with 10 nodes using flood';// graph name
NumberOfNodes=10;//no. of nodes
//every edge has head and tail.
EndingNodesOfConnection=[2 3 5 5 6 4 9 7 8 6];// tail of eatch edge, this is a node from a edge or link is originating 
StartNodesOfConnection=[1 1 3 4 2 9 7 8 10 10];//head of each edge,this is a node where edge or link is terminating 
// so, an edge can be represent as (tail,head),tail and head both are node no. eg.:   tail[1]=2,head[1]=1 means edge 1 is originating from 2 and terminating on 1 that implies there is an edge betweem node 1 and   node 2
XCoordinatesOfNodes=[200 400 100 350 200 500 550 600 500 550];// x-coordinate of each node
YCoordinatesOfNodes=[100 100 400 650 650 200 500 400 600 300];//y-coordinate of each node
[TopologyGraph]=NL_G_MakeGraph(NameOfNetwork,NumberOfNodes,EndingNodesOfConnection,StartNodesOfConnection,XCoordinatesOfNodes,YCoordinatesOfNodes)//application of NL_G_MakeGraph
NetworkSize=length(TopologyGraph.node_x);//real network size
NetworkQuantity=length(TopologyGraph.head);//quantity of network links
[Node1,Node2]=NL_F_RandIntNiNj(NetworkSize)//selection of two distinct nodes
TimeToLive=15;//Time-To-Live update
[path]=NL_R_Flood(TopologyGraph,Node1,Node2,TimeToLive)//application of NL_R_Flood
ShortestPath=NL_G_Nodes2Path(path,TopologyGraph);//links of the shortest path
EdgeColor=ones(1,NetworkQuantity);//display the path between i and j: edge color
EdgeBorder=1.5*ones(1,NetworkQuantity);//edge width
EdgeColor(ShortestPath)=5;//define path color
EdgeBorder(ShortestPath)=5;//define width 
NodeBorder=4*ones(1,NetworkSize);//node border
NodeBorder(path)=10;//node border for source to destination path
TopologyGraph.node_border=NodeBorder;//node border
TopologyGraph.edge_color=EdgeColor;//define edge color
TopologyGraph.edge_width=EdgeBorder;//edge width
WinodeNumber=1;//window index
GraphVisualize=NL_G_ShowGraphN(TopologyGraph,WinodeNumber);//graph visualization
xtitle("Shortest path in Ring Topology network using flood for 12 nodes","X-Nodes","Y-Nodes");
//This is the scilab code to find the Shortest path from source to destination in ring topology network using flood for 30 nodes. 
NameOfNetwork=' shortest path from source to destinetion in ring topology with 30 nodes using flood';// graph name
NumberOfNodes=30;//no. of nodes
//every edge has head and tail.
EndingNodesOfConnection=[2 20 4 9 7 8 11 5 16 11 12 3 13 1 1 15 17 18 19 20 6 22 21 23 26 27 24 30 29 28 30];// tail of eatch edge, this is a node from a edge or link is originating 
StartNodesOfConnection=[1 2 17 7 19 10 5 16 4 12 3 13 14 14 15 2 18 9 8 6 22 21 23 26 27 24 25 29 28 10 25];//head of each edge,this is a node where edge or link is terminating 
// so, an edge can be represent as (tail,head),tail and head both are node no. eg.:   tail[1]=2,head[1]=1 means edge 1 is originating from 2 and terminating on 1 that implies there is an edge betweem node 1 and   node 2
XCoordinatesOfNodes=[200 400 100 350 200 600 650 800 600 900 100 100 150 150 300 300 400 500 750 500 700 650 800 900 900 900 900 950 1000 950];// x-coordinate of each node
YCoordinatesOfNodes=[100 100 400 650 650 100 700 600 700 600 600 500 300 200 100 700 700 700 650 100 100 100 100 300 400 100 200 550 500 400];//y-coordinate of each node
[TopologyGraph]=NL_G_MakeGraph(NameOfNetwork,NumberOfNodes,EndingNodesOfConnection,StartNodesOfConnection,XCoordinatesOfNodes,YCoordinatesOfNodes)//application of NL_G_MakeGraph
NetworkSize=length(TopologyGraph.node_x);//real network size
NetworkQuantity=length(TopologyGraph.head);//quantity of network links
[Node1,Node2]=NL_F_RandIntNiNj(NetworkSize)//selection of two distinct nodes
TTL=15;//Time-To-Live update
[path]=NL_R_Flood(TopologyGraph,Node1,Node2,TTL)//application of NL_R_Flood
ShortestPath=NL_G_Nodes2Path(path,TopologyGraph);//links of the shortest path
EdgeColor=ones(1,NetworkQuantity);//display the path between i and j: edge color
EdgeBorder=1.5*ones(1,NetworkQuantity);//edge width
EdgeColor(ShortestPath)=5;//define path color
EdgeBorder(ShortestPath)=5;//define width 
NodeBorder=4*ones(1,NetworkSize);//node border
NodeBorder(path)=10;//node border for source to destination path
TopologyGraph.node_border=NodeBorder;//node border
TopologyGraph.edge_color=EdgeColor;//define edge color
TopologyGraph.edge_width=EdgeBorder;//edge width
WindowIndex=2;//window index
GraphVisualize=NL_G_ShowGraphN(TopologyGraph,WindowIndex);//graph visualization
xtitle("Shortest path in Ring Topology network using flood for 30 nodes","X-Nodes","Y-Nodes");
